/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class OreMeltingRecipe
extends MeltingRecipe {
    private final IMeltingContainer.OreRateType oreType;

    public OreMeltingRecipe(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, IMeltingContainer.OreRateType oreType) {
        super(id, group, input, output, temperature, time, byproducts);
        this.oreType = oreType;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        return inv.getOreRate().applyOreBoost(this.oreType, output);
    }

    @Override
    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.oreMeltingSerializer.get();
    }

    @Override
    public IMeltingContainer.OreRateType getOreType() {
        return this.oreType;
    }

    public static class Serializer
    extends MeltingRecipe.AbstractSerializer<OreMeltingRecipe> {
        @Override
        protected OreMeltingRecipe createFromJson(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            List<Object> scaledByproducts;
            IMeltingContainer.OreRateType rate = IMeltingContainer.OreRateType.parse(json, "rate");
            if (json.has("byproducts")) {
                List<IMeltingContainer.OreRateType> list = JsonHelper.parseList(json, "byproducts", (e, n) -> {
                    JsonObject byproduct = e.getAsJsonObject();
                    if (byproduct.has("rate")) {
                        return IMeltingContainer.OreRateType.parse(e.getAsJsonObject(), "rate");
                    }
                    return rate;
                });
                if (list.size() != byproducts.size()) {
                    throw new JsonSyntaxException("Wrong number of byproduct rates passed, must have one per byproduct");
                }
                scaledByproducts = Streams.zip(list.stream(), byproducts.stream(), Config.COMMON.foundryByproductRate::applyOreBoost).toList();
            } else {
                scaledByproducts = byproducts.stream().map(fluid -> Config.COMMON.foundryByproductRate.applyOreBoost(rate, (FluidStack)fluid)).toList();
            }
            return new OreMeltingRecipe(id, group, input, output, temperature, time, scaledByproducts, rate);
        }

        @Override
        protected OreMeltingRecipe createFromNetwork(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, class_2540 buffer) {
            IMeltingContainer.OreRateType rate = (IMeltingContainer.OreRateType)buffer.method_10818(IMeltingContainer.OreRateType.class);
            return new OreMeltingRecipe(id, group, input, output, temperature, time, byproducts, rate);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, OreMeltingRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.method_10817((Enum)recipe.oreType);
        }
    }
}

